<?php
// Error reporting - disable in production
error_reporting(0);
ini_set('display_errors', 0);

// Session optimization
ini_set('session.gc_maxlifetime', 1440);
ini_set('session.cookie_lifetime', 0);
ini_set('session.use_strict_mode', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1);

// Cache settings
define('CACHE_ENABLED', true);
define('CACHE_TIME', 3600); // 1 hour

// System settings
define('TIMEZONE', 'UTC');
date_default_timezone_set(TIMEZONE);

// Performance settings
ini_set('memory_limit', '256M');
ini_set('max_execution_time', 30);
ini_set('post_max_size', '8M');
ini_set('upload_max_filesize', '2M');

// Enable output compression
if (extension_loaded('zlib')) {
    ini_set('zlib.output_compression', 'On');
    ini_set('zlib.output_compression_level', '5');
}

// Start session with optimized settings
if (session_status() === PHP_SESSION_NONE) {
    session_start([
        'cookie_httponly' => true,
        'cookie_secure' => true,
        'cookie_samesite' => 'Strict',
        'gc_maxlifetime' => 1440,
        'use_strict_mode' => true
    ]);
}

// Include database configuration
require_once __DIR__ . '/database.php';

// Cache function
function getCache($key) {
    if (!CACHE_ENABLED) return false;
    $cacheFile = sys_get_temp_dir() . '/cache_' . md5($key);
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile) < CACHE_TIME)) {
        return unserialize(file_get_contents($cacheFile));
    }
    return false;
}

function setCache($key, $data) {
    if (!CACHE_ENABLED) return false;
    $cacheFile = sys_get_temp_dir() . '/cache_' . md5($key);
    return file_put_contents($cacheFile, serialize($data));
}

// Security functions
function sanitizeInput($data) {
    if (is_array($data)) {
        return array_map('sanitizeInput', $data);
    }
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// Performance monitoring
function startTimer() {
    return microtime(true);
}

function endTimer($start) {
    return microtime(true) - $start;
}

// Logging function
function logError($message, $context = []) {
    $logFile = __DIR__ . '/../logs/error.log';
    $timestamp = date('Y-m-d H:i:s');
    $contextStr = !empty($context) ? json_encode($context) : '';
    $logMessage = "[$timestamp] $message $contextStr\n";
    error_log($logMessage, 3, $logFile);
}
?> 